package com.ejie.p06b.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import javax.xml.bind.JAXBException;

//import com.ejie.p06b.manager.NotificationCData;
//import com.ejie.p06b.manager.contextSubmissionEvent.ContextSubmissionEvent; 
//import com.ejie.c42.x43.wsclient.Exception_Exception;
import com.ejie.aa87b.x43Toolkit.wsclient.Exception_Exception;
import com.ejie.p06b.manager.P06bMng;
//import com.ejie.folderManagement.xml.ContextSubmissionEventDocument.ContextSubmissionEvent;

//import com.ejie.p06b.manager.EjgvDocument;
//import com.ejie.p06b.manager.contextSubmissionEvent.ContextSubmissionEvent;
import com.ejie.aa87b.manager.contextSubmissionEvent.ContextSubmissionEvent;
import com.ejie.p06b.manager.ejgvDocument.EjgvDocument; 

import com.ejie.p06b.dao.solreclamacion.P06bAltaMediadoresDao;
import com.ejie.p06b.exception.P06BModMediadorException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.datatype.model.P06B81T00Datatype;

public class P06bProcessMessage {
	
	private Message message;
	
	/**
	 * Constructor por defecto
	 * 
	 * @param message
	 *            : Objeto de tipo Message con el mensaje de evento en
	 *            Tramitagune capturado por la clase MDB
	 */
	public P06bProcessMessage(Message message) {
		this.message = message;
	}
	
	/**
	 * Mtodo que contiene la lgica de procesamiento del mensaje de evento en
	 * Tramitagune
	 * @throws SQLException 
	 */
	public void onMessage(){
		
		P06B64T00Datatype p06B64T00Datatype = new P06B64T00Datatype();
		String sMensajeError = null;

		P06bAltaMediadoresDao p06bAltamediadoresDao = null;
		p06bAltamediadoresDao = new P06bAltaMediadoresDao();

		try{
			p06bAltamediadoresDao.conectar(P06bMng.getProperties());
			p06bAltamediadoresDao.fijarNumericCharacters();
		}catch(SQLException SQLe){
			sMensajeError = "conectar(P06bMng.getProperties()): " + SQLe.getMessage();
			P06BLog.send(0, this, sMensajeError);
			return;
		}catch(NamingException ne){
			sMensajeError = "conectar(P06bMng.getProperties()): " + ne.getMessage();
			P06BLog.send(0, this, sMensajeError);
			return;
		}catch(Exception e){
			sMensajeError = "conectar(P06bMng.getProperties()): " + e.getMessage();
			P06BLog.send(0, this, sMensajeError);
			return;
		}
		
		int correlAtencPetic = -1;
		try {
			correlAtencPetic = p06bAltamediadoresDao.getCorrelAtencPetic();
			p06B64T00Datatype.setCorrelativo(correlAtencPetic);
		} catch (SQLException sqle) {
			sMensajeError = "getCorrelAtencPetic(): " + sqle.getMessage();
			P06BLog.send(0, this, sMensajeError);
			return;
		}
		
		String sMessage = null;
		try{
			sMessage = ((TextMessage) this.message).getText();
			p06B64T00Datatype.setMensaje(sMessage);
		}catch (JMSException jmse){
			sMensajeError = "((TextMessage) this.message).getText(): " + jmse.getMessage();
			return;
		}catch (Exception e){
			sMensajeError = "((TextMessage) this.message).getText(): " + e.getMessage();
			return;
		}finally{
			if (sMensajeError!=null){
				P06BLog.send(0, this, sMensajeError);
				p06B64T00Datatype.setMensajeError(sMensajeError);
				try{
					p06bAltamediadoresDao.insertarAtencionPeticion(p06B64T00Datatype);				
					if (p06bAltamediadoresDao != null && !p06bAltamediadoresDao.isClosed()) {
						p06bAltamediadoresDao.desconectar();
					}
				}catch(SQLException sqle){
					sMensajeError = sMensajeError + ": " + sqle.getMessage();
					P06BLog.send(0, this, sMensajeError);
					return;
				}catch(Exception e){
					sMensajeError = sMensajeError + ": " + e.getMessage();
					P06BLog.send(0, this, sMensajeError);
					return;
				}
				return;
			}
		}
		try{
			ContextSubmissionEvent cData = null;
			cData = P06bMng.getNotificationCData(sMessage, p06B64T00Datatype );
			if(cData == null){
				sMensajeError = "cData == null";
			}else{
				p06B64T00Datatype.setIdSolicitudTramitagune(cData.getSolicitudID());
				p06B64T00Datatype.setRegistryNumber(cData.getRegistryNumber());
				p06B64T00Datatype.setProcedimiento(cData.getProcedureID());				
				if (cData.getSolicitudID()==null){
					sMensajeError = "cData.getSolicitudID()==null";				
				}else if (cData.getRegistryNumber()==null){
					sMensajeError = "cData.getRegistryNumber()==null";
				}else if (cData.getProcedureID()==null){
					sMensajeError = "cData.getProcedureID()==null";
				}
			}
			if (sMensajeError!=null){
				return;
			}
			EjgvDocument ejgvDoc = null;
			ejgvDoc = P06bMng.getRequestInformation(cData.getSolicitudID(), p06B64T00Datatype);
			if(ejgvDoc == null){
				sMensajeError = "ejgvDoc == null";
				return;
			}
			boolean estado = false;		
			if (cData.getProcedureID()==null){
				sMensajeError = "cData.getProcedureID()==null";
				return;			
			}
			if (!cData.getProcedureID().equals(P06bMng.PROCEDIMIENTO_ALTA_REG_MEDIADORES_SEGUROS) &&
					!cData.getProcedureID().equals(P06bMng.PROCEDIMIENTO_MODIF_REG_MEDIADORES_SEGUROS) &&
					!cData.getProcedureID().equals(P06bMng.PROCEDIMIENTO_CANCEL_REG_MEDIADORES_SEGUROS) &&
					!cData.getProcedureID().equals(P06bMng.PROCEDIMIENTO_AUTORIZACION_REG_MEDIADORES_SEGUROS)){
				sMensajeError = "Procedimiento no contemplado (" + cData.getProcedureID() + ")";
				return;
			}
			P06BLog.send(0,this, "Peticin de Id. " + cData.getSolicitudID() + "- cData.getProcedureID():" + cData.getProcedureID());
			if (cData.getProcedureID().equals(P06bMng.PROCEDIMIENTO_ALTA_REG_MEDIADORES_SEGUROS)){
				p06bAltamediadoresDao.insertarAtencionPeticion(p06B64T00Datatype);				
				estado = P06bMng.addAltaMediadoresToDB(p06bAltamediadoresDao,ejgvDoc,cData,p06B64T00Datatype);
				p06B64T00Datatype.setEstado(P06BConstantes.P06B_AP_ESTADO_ENSISTEMA);
//				p06bAltamediadoresDao.insertarAtencionPeticion(p06B64T00Datatype);				
				p06bAltamediadoresDao.modificarAtencionPeticion(p06B64T00Datatype);				
			}else if (cData.getProcedureID().equals(P06bMng.PROCEDIMIENTO_MODIF_REG_MEDIADORES_SEGUROS)){
				p06bAltamediadoresDao.insertarAtencionPeticion(p06B64T00Datatype);				
				estado = P06bMng.addModMediadoresToDB(p06bAltamediadoresDao,ejgvDoc,cData,p06B64T00Datatype);
				p06B64T00Datatype.setEstado(P06BConstantes.P06B_AP_ESTADO_PORREVISAR);
				p06bAltamediadoresDao.modificarAtencionPeticion(p06B64T00Datatype);				
			}else if (cData.getProcedureID().equals(P06bMng.PROCEDIMIENTO_AUTORIZACION_REG_MEDIADORES_SEGUROS)){
				p06bAltamediadoresDao.insertarAtencionPeticion(p06B64T00Datatype);				
				estado = P06bMng.addAutMediadoresToDB(p06bAltamediadoresDao,ejgvDoc,cData,p06B64T00Datatype);
				p06B64T00Datatype.setEstado(P06BConstantes.P06B_AP_ESTADO_ENSISTEMA);
				p06bAltamediadoresDao.modificarAtencionPeticion(p06B64T00Datatype);				
			}else{
				p06bAltamediadoresDao.insertarAtencionPeticion(p06B64T00Datatype);				
				estado = P06bMng.addCancelMediadoresToDB(p06bAltamediadoresDao,ejgvDoc,cData,p06B64T00Datatype);
				p06B64T00Datatype.setEstado(P06BConstantes.P06B_AP_ESTADO_ENSISTEMA);
				p06bAltamediadoresDao.modificarAtencionPeticion(p06B64T00Datatype);				
			}
		}catch(P06BModMediadorException p06bmme){
			sMensajeError = p06bmme.getMessage();
			return;
		}catch (JAXBException jaxbe){
			sMensajeError = "P06bMng.getNotificationCData(sMessage): " + jaxbe.getMessage();
			return;
		}catch (MalformedURLException mue) {
			sMensajeError = "P06bMng.getRequestInformation(cData.getSolicitudID()): en new X43KWebService_Service(new URL(" + P06bMng.X43TOOLKIT_URL + ")): " + mue.getMessage();
			return;
		}catch (Exception_Exception x43Exc) {
			sMensajeError = "P06bMng.getRequestInformation(cData.getSolicitudID()): en x43Service.getRequestInformation(cData.getSolicitudID(), null): " + x43Exc.getMessage();
			return;
		}catch (SQLException sqle) {
			sMensajeError = sqle.getMessage();
			return;
		}catch (Exception e){
			sMensajeError = "P06bMng.getNotificationCData(sMessage): " + e.getMessage();
			return;
		}finally{
			if (sMensajeError!=null){
				p06bAltamediadoresDao.rollback();
				P06BLog.send(0, this, sMensajeError);
				p06B64T00Datatype.setEstado(P06BConstantes.P06B_AP_ESTADO_PORCORREGIR);
				p06B64T00Datatype.setMensajeError(sMensajeError);
				try{
					p06bAltamediadoresDao.insertarAtencionPeticion(p06B64T00Datatype);				
					if (p06bAltamediadoresDao != null && !p06bAltamediadoresDao.isClosed()) {
						p06bAltamediadoresDao.desconectar();
					}
				}catch(SQLException sqle){
					sMensajeError = sMensajeError + ": " + sqle.getMessage();
					P06BLog.send(0, this, sMensajeError);
					return;
				}catch(Exception e){
					sMensajeError = sMensajeError + ": " + e.getMessage();
					P06BLog.send(0, this, sMensajeError);
					return;
				}
				return;
			}else{
				try{
					P06BLog.send(0, this, "(onMessage) Previo 1 a capturada y almacenada en base de datos correctamente");
					if (p06bAltamediadoresDao != null && !p06bAltamediadoresDao.isClosed()) {
						P06BLog.send(0, this, "(onMessage) Previo 2 a peticin capturada y almacenada en base de datos correctamente");
						p06bAltamediadoresDao.desconectar();
						P06BLog.send(0, this, "(onMessage) Peticin capturada y almacenada en base de datos correctamente");
					}
				}catch(SQLException sqle){
					sMensajeError = sMensajeError + ": " + sqle.getMessage();
					P06BLog.send(0, this, sMensajeError);
					return;
				}catch(Exception e){
					sMensajeError = sMensajeError + ": " + e.getMessage();
					P06BLog.send(0, this, sMensajeError);
					return;
				}
			}
		}
				
	}
}
